/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.gui.widgetwrapper.FileChooserProxy;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;

public class SaveProfileWorker
extends SwingWorker<ProfileInstance, Void> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ProfileManager profileManager;
    private Path destination;
    private ProfileForm profileForm;
    private ProgressObserver callback;
    private FileChooserProxy dialog;
    private String profileId;

    public SaveProfileWorker(ProfileManager profileManager, ProfileForm profileForm, FileChooserProxy dialog) {
        this.dialog = dialog;
        this.profileManager = profileManager;
        this.profileForm = profileForm;
        ProfileInstance profile = profileForm.getProfile();
        this.profileId = profile.getUuid();
        this.callback = new ProgressObserver(){

            public void onProgress(Integer progress) {
                SaveProfileWorker.this.setProgress(progress);
            }
        };
    }

    public SwingWorker<ProfileInstance, Void> start(boolean saveAs) {
        boolean cancelled = false;
        this.destination = this.profileForm.getProfile().getLoadedFrom();
        if (this.destination == null || saveAs) {
            if (this.dialog.getResponse() == 1) {
                this.destination = this.dialog.getSelectedFile().toPath();
                this.save();
            } else {
                cancelled = true;
            }
        } else if (this.profileForm.getProfile().isDirty()) {
            this.save();
        }
        return cancelled ? null : this;
    }

    private void save() {
        this.profileForm.beforeSave();
        final JProgressBar statusProgressBar = this.profileForm.getStatusProgressBar();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName())) {
                    statusProgressBar.setValue((Integer)evt.getNewValue());
                }
            }
        });
        this.execute();
    }

    @Override
    protected ProfileInstance doInBackground() throws IOException {
        ProfileInstance profile = this.profileManager.save(this.profileId, this.destination, this.callback);
        return profile;
    }

    @Override
    protected void done() {
        try {
            ProfileInstance profile = (ProfileInstance)this.get();
            this.profileForm.setName(profile.getName());
        }
        catch (InterruptedException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.profileForm.afterSave();
        }
    }
}

