/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.action;

import java.awt.Component;
import java.util.List;
import javax.swing.JOptionPane;
import uk.gov.nationalarchives.droid.gui.DroidUIContext;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.profile.ProfileManager;

public class StopRunningProfilesAction {
    private DroidUIContext context;
    private ProfileManager profileManager;
    private Component parent;

    public StopRunningProfilesAction(ProfileManager profileManager, DroidUIContext context, Component parent) {
        this.profileManager = profileManager;
        this.context = context;
        this.parent = parent;
    }

    public boolean execute() {
        boolean profilesStopped;
        List<ProfileForm> runningProfiles = this.context.allRunningProfiles();
        if (runningProfiles.isEmpty()) {
            profilesStopped = true;
        } else {
            int response = JOptionPane.showConfirmDialog(this.parent, "Running profiles must be stopped before DROID closes. Do you want to stop running profiles?", "Warning", 0, 2);
            if (response == 0) {
                for (ProfileForm profile : runningProfiles) {
                    this.profileManager.stop(profile.getProfile().getUuid());
                }
                profilesStopped = true;
            } else {
                profilesStopped = false;
            }
        }
        return profilesStopped;
    }
}

