/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.config;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.apache.commons.collections4.list.SetUniqueList;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.observablecollections.ObservableList;
import org.jdesktop.observablecollections.ObservableMap;
import org.jdesktop.swingbinding.JComboBoxBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.openide.util.NbBundle;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureType;
import uk.gov.nationalarchives.droid.gui.GlobalContext;
import uk.gov.nationalarchives.droid.gui.config.UpdateProxyConfigDialog;

public class ConfigDialog
extends JDialog {
    public static final int CANCEL = 0;
    public static final int OK = 1;
    private static final long serialVersionUID = -707594144365104572L;
    private static final String PRONOM_SIGNATURE_URL_KEY = "pronom.update.url";
    private static final String PRONOM_CONTAINER_URL_KEY = "container.update.url";
    private int response;
    private Map<String, Object> props = new HashMap<String, Object>();
    private GlobalContext context;
    private ObservableMap<String, Object> globalConfig = ObservableCollections.observableMap(this.props);
    private ObservableList<String> allHashAlgorithms = ObservableCollections.observableList((List)SetUniqueList.setUniqueList(new ArrayList()));
    private ObservableList<String> allBinarySigFiles = ObservableCollections.observableList((List)SetUniqueList.setUniqueList(new ArrayList()));
    private ObservableList<String> allContainerSigFiles = ObservableCollections.observableList((List)SetUniqueList.setUniqueList(new ArrayList()));
    private JLabel archivesLabel;
    private JCheckBox askToDownloadCheckBox;
    private JCheckBox autoSetDefaultSignatureFileCheckBox;
    private JCheckBox autoUpdateCheckbox;
    private JPanel autoUpdatePanel;
    private ButtonGroup buttonGroupExtension;
    private JButton cancelButton;
    private JComboBox containerSigCombo;
    private JLabel containerSigFileLabel;
    private JTextField containerSigUrl;
    private ButtonGroup csvExportButtonGroup;
    private JComboBox defaultSigFileComboBox1;
    private JFormattedTextField defaultThrottleTextBox1;
    private JTabbedPane generalTabbedPane1;
    private JCheckBox generateHashCheckBox;
    private JComboBox hashAlgorithmCombo;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JButton okButton;
    private JCheckBox process7zipCheckBox;
    private JCheckBox processArcCheckBox;
    private JCheckBox processBzip2CheckBox;
    private JCheckBox processGzipCheckBox;
    private JCheckBox processIsoCheckBox;
    private JCheckBox processRarCheckBox;
    private JCheckBox processTarCheckBox;
    private JCheckBox processWarcCheckBox;
    private JCheckBox processZipCheckBox;
    private JButton pronomUrlResetButton;
    private JButton proxySettingsButton;
    private JRadioButton rowPerFileButton1;
    private JRadioButton rowPerFileButton2;
    private JRadioButton rowPerFormatButton1;
    private JRadioButton rowPerFormatButton2;
    private JButton toggleArchivesButton;
    private JButton toggleWebArchivesButton;
    private ButtonGroup updateFrequencyButtonGroup;
    private JSpinner updateFrequencyTextBox;
    private JRadioButton updateOnStartupRadioButton;
    private JRadioButton updateScheduleRadioButton;
    private JTextField updateUrlTextBox;
    private JLabel webArchivesLabel;
    private BindingGroup bindingGroup;

    public ConfigDialog(Frame owner, GlobalContext context) {
        super(owner, true);
        this.context = context;
        this.init(context.getGlobalConfig().getPropertiesMap());
        this.initComponents();
        this.setPanelComponents(this.autoUpdatePanel, this.autoUpdateCheckbox.isSelected());
        this.updateFrequencyTextBox.setEnabled(this.updateScheduleRadioButton.isSelected() && this.autoUpdateCheckbox.isSelected());
        this.setLocationRelativeTo(owner);
    }

    public void init(Map<String, Object> properties) {
        this.response = 0;
        this.props.putAll(properties);
        Map<SignatureType, SortedMap<String, SignatureFileInfo>> allSignatureFiles = this.context.getActionFactory().newListSignatureFilesAction().list();
        ArrayList availableAlgorithms = (ArrayList)properties.get("availableHashAlgorithms");
        Object defaultHashAlgorithm = this.globalConfig.get((Object)DroidGlobalProperty.HASH_ALGORITHM.getName());
        this.allHashAlgorithms.addAll((Collection)availableAlgorithms);
        if (this.allHashAlgorithms.contains(defaultHashAlgorithm)) {
            this.globalConfig.put((Object)DroidGlobalProperty.HASH_ALGORITHM.getName(), defaultHashAlgorithm);
        }
        Object defaultSigFileVersion = this.globalConfig.get((Object)DroidGlobalProperty.DEFAULT_BINARY_SIG_FILE_VERSION.getName());
        this.allBinarySigFiles.addAll(allSignatureFiles.get(SignatureType.BINARY).keySet());
        if (!this.allBinarySigFiles.isEmpty() && this.allBinarySigFiles.contains(defaultSigFileVersion)) {
            this.globalConfig.put((Object)DroidGlobalProperty.DEFAULT_BINARY_SIG_FILE_VERSION.getName(), defaultSigFileVersion);
        }
        Object defaultContainerSigFileVersion = this.globalConfig.get((Object)DroidGlobalProperty.DEFAULT_CONTAINER_SIG_FILE_VERSION.getName());
        this.allContainerSigFiles.addAll(allSignatureFiles.get(SignatureType.CONTAINER).keySet());
        if (!this.allContainerSigFiles.isEmpty() && this.allContainerSigFiles.contains(defaultContainerSigFileVersion)) {
            this.globalConfig.put((Object)DroidGlobalProperty.DEFAULT_CONTAINER_SIG_FILE_VERSION.getName(), defaultContainerSigFileVersion);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.updateFrequencyButtonGroup = new ButtonGroup();
        this.csvExportButtonGroup = new ButtonGroup();
        this.buttonGroupExtension = new ButtonGroup();
        this.generalTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.defaultThrottleTextBox1 = new JFormattedTextField();
        this.jLabel4 = new JLabel();
        this.jLabel11 = new JLabel();
        this.defaultSigFileComboBox1 = new JComboBox();
        this.generateHashCheckBox = new JCheckBox();
        this.containerSigCombo = new JComboBox();
        this.containerSigFileLabel = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel9 = new JLabel();
        this.rowPerFileButton2 = new JRadioButton();
        this.rowPerFormatButton2 = new JRadioButton();
        this.hashAlgorithmCombo = new JComboBox();
        this.jLabel10 = new JLabel();
        this.jPanel4 = new JPanel();
        this.processZipCheckBox = new JCheckBox();
        this.processTarCheckBox = new JCheckBox();
        this.processGzipCheckBox = new JCheckBox();
        this.processRarCheckBox = new JCheckBox();
        this.process7zipCheckBox = new JCheckBox();
        this.processIsoCheckBox = new JCheckBox();
        this.processBzip2CheckBox = new JCheckBox();
        this.toggleArchivesButton = new JButton();
        this.archivesLabel = new JLabel();
        this.jPanel6 = new JPanel();
        this.webArchivesLabel = new JLabel();
        this.processArcCheckBox = new JCheckBox();
        this.processWarcCheckBox = new JCheckBox();
        this.toggleWebArchivesButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.rowPerFileButton1 = new JRadioButton();
        this.rowPerFormatButton1 = new JRadioButton();
        this.jPanel5 = new JPanel();
        this.jLabel5 = new JLabel();
        this.updateUrlTextBox = new JTextField();
        this.autoUpdatePanel = new JPanel();
        this.updateFrequencyTextBox = new JSpinner();
        this.jLabel6 = new JLabel();
        this.updateOnStartupRadioButton = new JRadioButton();
        this.updateScheduleRadioButton = new JRadioButton();
        this.autoUpdateCheckbox = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.proxySettingsButton = new JButton();
        this.containerSigUrl = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.askToDownloadCheckBox = new JCheckBox();
        this.autoSetDefaultSignatureFileCheckBox = new JCheckBox();
        this.pronomUrlResetButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.title"));
        this.setMinimumSize(new Dimension(500, 600));
        this.jPanel3.setPreferredSize(new Dimension(500, 380));
        this.jLabel3.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jLabel1.text"));
        this.defaultThrottleTextBox1.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.defaultThrottle\"]}"), (Object)this.defaultThrottleTextBox1, (Property)BeanProperty.create((String)"value"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel4.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jLabel2.text"));
        this.jLabel11.setLabelFor(this.defaultSigFileComboBox1);
        this.jLabel11.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jLabel10.text"));
        ELProperty eLProperty = ELProperty.create((String)"${allBinarySigFiles}");
        JComboBoxBinding jComboBoxBinding = SwingBindings.createJComboBoxBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)eLProperty, (JComboBox)this.defaultSigFileComboBox1);
        this.bindingGroup.addBinding((Binding)jComboBoxBinding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.defaultBinarySigFileVersion\"]}"), (Object)this.defaultSigFileComboBox1, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.generateHashCheckBox.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.generateHashCheckBox.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.generateHash\"]}"), (Object)this.generateHashCheckBox, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.generateHashCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.generateHashCheckBoxActionPerformed(evt);
            }
        });
        eLProperty = ELProperty.create((String)"${allContainerSigFiles}");
        jComboBoxBinding = SwingBindings.createJComboBoxBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)eLProperty, (JComboBox)this.containerSigCombo);
        this.bindingGroup.addBinding((Binding)jComboBoxBinding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.defaultContainerSigFileVersion\"]}"), (Object)this.containerSigCombo, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.containerSigCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.containerSigComboActionPerformed(evt);
            }
        });
        this.containerSigFileLabel.setLabelFor(this.containerSigCombo);
        this.containerSigFileLabel.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.containerSigFileLabel.text_1"));
        this.jTextField2.setHorizontalAlignment(4);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.maxBytesToScan\"]}"), (Object)this.jTextField2, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel9.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jLabel9.text"));
        this.buttonGroupExtension.add(this.rowPerFileButton2);
        this.rowPerFileButton2.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.rowPerFileButton2.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${!globalConfig[\"profile.matchAllExtensions\"]}"), (Object)this.rowPerFileButton2, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.buttonGroupExtension.add(this.rowPerFormatButton2);
        this.rowPerFormatButton2.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.rowPerFormatButton2.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.matchAllExtensions\"]}"), (Object)this.rowPerFormatButton2, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        eLProperty = ELProperty.create((String)"${allHashAlgorithms}");
        jComboBoxBinding = SwingBindings.createJComboBoxBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)eLProperty, (JComboBox)this.hashAlgorithmCombo);
        this.bindingGroup.addBinding((Binding)jComboBoxBinding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.hashAlgorithm\"]}"), (Object)this.hashAlgorithmCombo, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.hashAlgorithmCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.hashAlgorithmComboActionPerformed(evt);
            }
        });
        this.jLabel10.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jLabel10.text_1"));
        this.processZipCheckBox.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.processZipCheckBox.text"));
        this.processZipCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.processZipCheckBoxActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.processZip\"]}"), (Object)this.processZipCheckBox, (Property)BeanProperty.create((String)"selected"), (String)"zipBinding");
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        this.processTarCheckBox.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.processTarCheckBox.text"));
        this.processTarCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.processTarCheckBoxActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.processTar\"]}"), (Object)this.processTarCheckBox, (Property)BeanProperty.create((String)"selected"), (String)"tarBinding");
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        this.processGzipCheckBox.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.processGzipCheckBox.text"));
        this.processGzipCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.processGzipCheckBoxActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.processGzip\"]}"), (Object)this.processGzipCheckBox, (Property)BeanProperty.create((String)"selected"), (String)"gzipBinding");
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        this.processRarCheckBox.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.processRarCheckBox.text"));
        this.processRarCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.processRarCheckBoxActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.processRar\"]}"), (Object)this.processRarCheckBox, (Property)BeanProperty.create((String)"selected"), (String)"rarBinding");
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        this.process7zipCheckBox.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.process7zipCheckBox.text"));
        this.process7zipCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.process7zipCheckBoxActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.process7zip\"]}"), (Object)this.process7zipCheckBox, (Property)BeanProperty.create((String)"selected"), (String)"7zipBinding");
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        this.processIsoCheckBox.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.processIsoCheckBox.text"));
        this.processIsoCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.processIsoCheckBoxActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.processIso\"]}"), (Object)this.processIsoCheckBox, (Property)BeanProperty.create((String)"selected"), (String)"isoBinding");
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        this.processBzip2CheckBox.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.processBzip2CheckBox.text"));
        this.processBzip2CheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.processBzip2CheckBoxActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.processBzip2\"]}"), (Object)this.processBzip2CheckBox, (Property)BeanProperty.create((String)"selected"), (String)"bzip2Binding");
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        this.toggleArchivesButton.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.toggleArchivesButton.text"));
        this.toggleArchivesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.toggleArchivesButtonActionPerformed(evt);
            }
        });
        this.archivesLabel.setLabelFor(this.containerSigCombo);
        this.archivesLabel.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.archivesLabel.text"));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(42, 42, 42).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toggleArchivesButton).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.processZipCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.processTarCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.processGzipCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.processRarCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.process7zipCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.processIsoCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.processBzip2CheckBox))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.archivesLabel, -2, 461, -2).addGap(0, 121, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.archivesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.toggleArchivesButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.processZipCheckBox).addComponent(this.processTarCheckBox).addComponent(this.processGzipCheckBox).addComponent(this.process7zipCheckBox).addComponent(this.processRarCheckBox).addComponent(this.processIsoCheckBox).addComponent(this.processBzip2CheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        this.webArchivesLabel.setLabelFor(this.containerSigCombo);
        this.webArchivesLabel.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.webArchivesLabel.text"));
        this.processArcCheckBox.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.processArcCheckBox.text"));
        this.processArcCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.processArcCheckBoxActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.processArc\"]}"), (Object)this.processArcCheckBox, (Property)BeanProperty.create((String)"selected"), (String)"arcBinding");
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        this.processWarcCheckBox.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.processWarcCheckBox.text"));
        this.processWarcCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.processWarcCheckBoxActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"profile.processWarc\"]}"), (Object)this.processWarcCheckBox, (Property)BeanProperty.create((String)"selected"), (String)"warcBinding");
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        this.toggleWebArchivesButton.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.toggleWebArchivesButton.text"));
        this.toggleWebArchivesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.toggleWebArchivesButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.webArchivesLabel, -1, -1, Short.MAX_VALUE).addGroup(jPanel6Layout.createSequentialGroup().addGap(42, 42, 42).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.processArcCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.processWarcCheckBox)).addComponent(this.toggleWebArchivesButton)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.webArchivesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.toggleWebArchivesButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.processArcCheckBox).addComponent(this.processWarcCheckBox))));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel11, -1, -1, Short.MAX_VALUE).addComponent(this.containerSigFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultSigFileComboBox1, 0, -1, Short.MAX_VALUE).addComponent(this.containerSigCombo, 0, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel10, -2, 418, -2).addContainerGap()).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.generateHashCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hashAlgorithmCombo, -2, 110, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel9, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, 1, Short.MAX_VALUE))).addGap(20, 20, 20)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rowPerFileButton2).addComponent(this.rowPerFormatButton2).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.defaultThrottleTextBox1, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel6, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.defaultSigFileComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.containerSigCombo, -2, -1, -2).addComponent(this.containerSigFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.generateHashCheckBox).addComponent(this.hashAlgorithmCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9, -2, -1, -2).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rowPerFileButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowPerFormatButton2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.defaultThrottleTextBox1, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel10).addContainerGap(156, Short.MAX_VALUE)));
        this.generalTabbedPane1.addTab(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jPanel2.TabConstraints.tabTitle"), this.jPanel3);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jPanel1.border.title_1")));
        this.csvExportButtonGroup.add(this.rowPerFileButton1);
        this.rowPerFileButton1.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.rowPerFileButton1.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${!globalConfig[\"export.rowPerFormat\"]}"), (Object)this.rowPerFileButton1, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.csvExportButtonGroup.add(this.rowPerFormatButton1);
        this.rowPerFormatButton1.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.rowPerFormatButton1.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"export.rowPerFormat\"]}"), (Object)this.rowPerFormatButton1, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.rowPerFormatButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.rowPerFormatButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.rowPerFormatButton1, -1, -1, Short.MAX_VALUE).addComponent(this.rowPerFileButton1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.rowPerFileButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rowPerFormatButton1).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(596, Short.MAX_VALUE)));
        this.generalTabbedPane1.addTab(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jPanel2.TabConstraints.tabTitle_1"), this.jPanel2);
        this.jPanel5.setPreferredSize(new Dimension(544, 290));
        this.jPanel5.setRequestFocusEnabled(false);
        this.jLabel5.setLabelFor(this.updateUrlTextBox);
        this.jLabel5.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jLabel5.text"));
        this.jLabel5.setToolTipText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jLabel5.toolTipText"));
        this.updateUrlTextBox.setToolTipText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.updateUrlTextBox.toolTipText"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"pronom.update.url\"]}"), (Object)this.updateUrlTextBox, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.updateUrlTextBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.updateUrlTextBoxActionPerformed(evt);
            }
        });
        this.autoUpdatePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(""), NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.autoUpdatePanel.border.title")));
        this.autoUpdatePanel.setEnabled(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"update.frequency.days\"]}"), (Object)this.updateFrequencyTextBox, (Property)BeanProperty.create((String)"value"));
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.updateScheduleRadioButton, (Property)ELProperty.create((String)"${selected}"), (Object)this.updateFrequencyTextBox, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel6.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jLabel4.text"));
        this.updateFrequencyButtonGroup.add(this.updateOnStartupRadioButton);
        this.updateOnStartupRadioButton.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.updateOnStartupRadioButton.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"update.frequency.startup\"]}"), (Object)this.updateOnStartupRadioButton, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.updateOnStartupRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.updateOnStartupRadioButtonActionPerformed(evt);
            }
        });
        this.updateFrequencyButtonGroup.add(this.updateScheduleRadioButton);
        this.updateScheduleRadioButton.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.updateScheduleRadioButton.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_ONCE, (Object)this, (Property)ELProperty.create((String)"${!globalConfig[\"update.frequency.startup\"]}"), (Object)this.updateScheduleRadioButton, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout autoUpdatePanelLayout = new GroupLayout(this.autoUpdatePanel);
        this.autoUpdatePanel.setLayout(autoUpdatePanelLayout);
        autoUpdatePanelLayout.setHorizontalGroup(autoUpdatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(autoUpdatePanelLayout.createSequentialGroup().addContainerGap().addGroup(autoUpdatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.updateOnStartupRadioButton).addGroup(autoUpdatePanelLayout.createSequentialGroup().addComponent(this.updateScheduleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateFrequencyTextBox, -2, 66, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6))).addContainerGap(-1, Short.MAX_VALUE)));
        autoUpdatePanelLayout.setVerticalGroup(autoUpdatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(autoUpdatePanelLayout.createSequentialGroup().addComponent(this.updateOnStartupRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(autoUpdatePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updateFrequencyTextBox, -2, -1, -2).addComponent(this.updateScheduleRadioButton).addComponent(this.jLabel6)).addGap(12, 12, 12)));
        this.autoUpdateCheckbox.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.autoUpdateCheckbox.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"update.autoCheck\"]}"), (Object)this.autoUpdateCheckbox, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.autoUpdateCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.autoUpdateItemStateChanged(evt);
            }
        });
        this.jLabel7.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jLabel6.text"));
        this.proxySettingsButton.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.proxySettingsButton.text"));
        this.proxySettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.proxySettingsButtonActionPerformed(evt);
            }
        });
        this.containerSigUrl.setToolTipText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.containerSigUrl.toolTipText"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"container.update.url\"]}"), (Object)this.containerSigUrl, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel2.setLabelFor(this.containerSigUrl);
        this.jLabel2.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jLabel2.text_1"));
        this.jLabel2.setToolTipText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jLabel2.toolTipText"));
        this.jLabel1.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jLabel1.text_1"));
        this.jLabel1.setToolTipText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jLabel1.toolTipText"));
        this.jTextField1.setToolTipText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jLabel1.toolTipText"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"puid.urlPattern\"]}"), (Object)this.jTextField1, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST"));
        this.bindingGroup.addBinding((Binding)binding);
        this.askToDownloadCheckBox.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.askToDownloadCheckBox.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"update.downloadPrompt\"]}"), (Object)this.askToDownloadCheckBox, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.autoSetDefaultSignatureFileCheckBox.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.autoSetDefaultSignatureFileCheckBox.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${globalConfig[\"update.autoSetDefault\"]}"), (Object)this.autoSetDefaultSignatureFileCheckBox, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.autoSetDefaultSignatureFileCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.autoSetDefaultSignatureFileCheckBoxActionPerformed(evt);
            }
        });
        this.pronomUrlResetButton.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.pronomUrlResetButton.text"));
        this.pronomUrlResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.pronomUrlResetButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.pronomUrlResetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proxySettingsButton).addContainerGap()).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.askToDownloadCheckBox, -1, -1, Short.MAX_VALUE).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoSetDefaultSignatureFileCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.autoUpdateCheckbox, -1, -1, Short.MAX_VALUE).addComponent(this.autoUpdatePanel, -1, -1, Short.MAX_VALUE).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.containerSigUrl).addComponent(this.updateUrlTextBox))).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel7).addGap(0, 270, Short.MAX_VALUE)).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 143, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1))).addContainerGap()))));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.updateUrlTextBox, -2, -1, -2)).addGap(17, 17, 17).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.containerSigUrl, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proxySettingsButton).addComponent(this.pronomUrlResetButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoUpdateCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.askToDownloadCheckBox).addGap(5, 5, 5).addComponent(this.autoSetDefaultSignatureFileCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.autoUpdatePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.generalTabbedPane1.addTab(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.jPanel3.TabConstraints.tabTitle"), this.jPanel5);
        this.cancelButton.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText(NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.okButton.text"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton)).addComponent(this.generalTabbedPane1)).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.generalTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        layout.linkSize(1, this.cancelButton, this.okButton);
        this.bindingGroup.bind();
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.response = 1;
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void proxySettingsButtonActionPerformed(ActionEvent evt) {
        UpdateProxyConfigDialog proxyDialog = new UpdateProxyConfigDialog((Window)this, this.props);
        proxyDialog.setVisible(true);
        if (proxyDialog.getResponse() == 1) {
            this.globalConfig.putAll(proxyDialog.getProperties());
        }
    }

    private void updateOnStartupRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void autoSetDefaultSignatureFileCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void updateUrlTextBoxActionPerformed(ActionEvent evt) {
    }

    private void rowPerFormatButton1ActionPerformed(ActionEvent evt) {
    }

    private void pronomUrlResetButtonActionPerformed(ActionEvent evt) {
        String pronomSignatureUrl = this.context.getGlobalConfig().getDefaultProperties().getString(PRONOM_SIGNATURE_URL_KEY);
        String pronomContainerUrl = this.context.getGlobalConfig().getDefaultProperties().getString(PRONOM_CONTAINER_URL_KEY);
        this.updateUrlTextBox.setText(pronomSignatureUrl);
        this.containerSigUrl.setText(pronomContainerUrl);
    }

    private void toggleArchivesButtonActionPerformed(ActionEvent evt) {
        if (!(this.processTarCheckBox.isSelected() && this.processZipCheckBox.isSelected() && this.processGzipCheckBox.isSelected() && this.processRarCheckBox.isSelected() && this.process7zipCheckBox.isSelected() && this.processIsoCheckBox.isSelected() && this.processBzip2CheckBox.isSelected())) {
            this.processTarCheckBox.setSelected(true);
            this.processZipCheckBox.setSelected(true);
            this.processGzipCheckBox.setSelected(true);
            this.processRarCheckBox.setSelected(true);
            this.process7zipCheckBox.setSelected(true);
            this.processIsoCheckBox.setSelected(true);
            this.processBzip2CheckBox.setSelected(true);
        } else {
            this.processTarCheckBox.setSelected(false);
            this.processZipCheckBox.setSelected(false);
            this.processGzipCheckBox.setSelected(false);
            this.processRarCheckBox.setSelected(false);
            this.process7zipCheckBox.setSelected(false);
            this.processIsoCheckBox.setSelected(false);
            this.processBzip2CheckBox.setSelected(false);
        }
    }

    private void processIsoCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void process7zipCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void processRarCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void processGzipCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void processTarCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void processZipCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void hashAlgorithmComboActionPerformed(ActionEvent evt) {
    }

    private void containerSigComboActionPerformed(ActionEvent evt) {
    }

    private void generateHashCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void processBzip2CheckBoxActionPerformed(ActionEvent evt) {
    }

    private void processArcCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void processWarcCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void toggleWebArchivesButtonActionPerformed(ActionEvent evt) {
        if (!this.processArcCheckBox.isSelected() || !this.processWarcCheckBox.isSelected()) {
            this.processArcCheckBox.setSelected(true);
            this.processWarcCheckBox.setSelected(true);
        } else {
            this.processArcCheckBox.setSelected(false);
            this.processWarcCheckBox.setSelected(false);
        }
    }

    private void setPanelComponents(JPanel panel, boolean enabled) {
        panel.setEnabled(enabled);
        for (Component c : panel.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    private void autoUpdateItemStateChanged(ItemEvent evt) {
        this.setPanelComponents(this.autoUpdatePanel, evt.getStateChange() == 1);
        if (evt.getStateChange() == 1) {
            this.updateFrequencyTextBox.setEnabled(this.updateScheduleRadioButton.isSelected());
        }
    }

    public int getResponse() {
        return this.response;
    }

    JFormattedTextField getDefaultThrottleTextBox() {
        return this.defaultThrottleTextBox1;
    }

    JComboBox getHashAlgorithmCombo() {
        return this.hashAlgorithmCombo;
    }

    JButton getCancelButton() {
        return this.cancelButton;
    }

    JButton getOkButton() {
        return this.okButton;
    }

    public Map<String, Object> getGlobalConfig() {
        return this.globalConfig;
    }

    public List<String> getAllBinarySigFiles() {
        return this.allBinarySigFiles;
    }

    public List<String> getAllHashAlgorithms() {
        return this.allHashAlgorithms;
    }

    public List<String> getAllContainerSigFiles() {
        return this.allContainerSigFiles;
    }
}

