/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.export;

import java.io.File;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.export.interfaces.ExportManager;
import uk.gov.nationalarchives.droid.export.interfaces.ExportOptions;
import uk.gov.nationalarchives.droid.gui.action.ActionDoneCallback;

public class ExportAction
extends SwingWorker<Void, Integer> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ExportManager exportManager;
    private File destination;
    private ExportOptions options;
    private String outputEncoding;
    private boolean bom;
    private List<String> profileIds;
    private ActionDoneCallback<ExportAction> callback;
    private Future<?> exportTask;

    public ExportAction() {
    }

    public ExportAction(ExportManager exportManager, File destination, ExportOptions options, String outputEncoding, boolean bom, List<String> profileIds) {
        this.setExportManager(exportManager);
        this.setDestination(destination);
        this.setExportOptions(options);
        this.setOutputEncoding(outputEncoding);
        this.setBom(bom);
        this.setProfileIds(profileIds);
    }

    public void init() {
    }

    @Override
    protected void done() {
        this.callback.done(this);
    }

    @Override
    protected void process(List<Integer> chunks) {
        super.process(chunks);
    }

    @Override
    protected Void doInBackground() {
        this.exportTask = this.exportManager.exportProfiles(this.profileIds, this.destination.getPath(), null, this.options, this.outputEncoding, this.bom);
        try {
            this.exportTask.get();
        }
        catch (InterruptedException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.log.error(e.getCause().toString(), (Throwable)e);
            throw new RuntimeException(e.getCause());
        }
        catch (CancellationException e) {
            this.cancel(false);
            this.log.info("Export task was cancelled");
        }
        return null;
    }

    public void setExportManager(ExportManager exportManager) {
        this.exportManager = exportManager;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public void setExportOptions(ExportOptions opt) {
        this.options = opt;
    }

    public void setProfileIds(List<String> profileIds) {
        this.profileIds = profileIds;
    }

    public void setCallback(ActionDoneCallback<ExportAction> callback) {
        this.callback = callback;
    }

    public void cancel() {
        this.exportTask.cancel(true);
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setBom(boolean bom) {
        this.bom = bom;
    }
}

