/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.filter;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.openide.util.NbBundle;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterValue;
import uk.gov.nationalarchives.droid.gui.filter.domain.GenericMetadata;
import uk.gov.nationalarchives.droid.profile.FilterCriterionImpl;

public class ValuesDialog
extends JDialog {
    private static final long serialVersionUID = -6126734059735497128L;
    private FilterCriterionImpl filterCriteria;
    private String selectedString = "";
    private List<FilterValue> tempSelectedValues;
    private DefaultListModel possibleListModel = new DefaultListModel();
    private DefaultListModel selectedListModel = new DefaultListModel();
    private String selectedValues = "";
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JButton jButtonRemove;
    private JButton jButtonSelect;
    private JLabel jLabel1;
    private JList jListPossibleValues;
    private JList jListSelectedValues;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public ValuesDialog(Dialog parent, boolean modal, GenericMetadata metadata, FilterCriterionImpl filterCriteria) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.filterCriteria = filterCriteria;
        this.tempSelectedValues = filterCriteria.getSelectedValues();
        this.jLabel1.setText("");
        if (filterCriteria.getSelectedValues() != null) {
            int i;
            for (i = 0; i < metadata.getPossibleValues().size(); ++i) {
                this.possibleListModel.add(i, metadata.getPossibleValues().get(i));
            }
            for (i = 0; i < filterCriteria.getSelectedValues().size(); ++i) {
                this.selectedListModel.add(i, filterCriteria.getSelectedValues().get(i));
            }
            for (FilterValue values : filterCriteria.getSelectedValues()) {
                this.possibleListModel.remove(this.findIndexes(values.getDescription()));
            }
        } else {
            for (int i = 0; i < metadata.getPossibleValues().size(); ++i) {
                this.possibleListModel.add(i, metadata.getPossibleValues().get(i));
            }
        }
        this.jListPossibleValues.setModel(this.possibleListModel);
        this.jListSelectedValues.setModel(this.selectedListModel);
    }

    public String getSelectedValues() {
        return this.selectedValues;
    }

    public String getSelectedString() {
        return this.selectedString;
    }

    public void setSelectedValues(String selectedValues) {
        this.selectedValues = selectedValues;
    }

    private int findIndexes(String valuesNameFromSelectedModel) {
        for (int j = 0; j < this.possibleListModel.getSize(); ++j) {
            String valuesNameFromPossibleModel = ((FilterValue)this.possibleListModel.get(j)).getDescription();
            if (!valuesNameFromPossibleModel.equals(valuesNameFromSelectedModel)) continue;
            return j;
        }
        return 0;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListPossibleValues = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jListSelectedValues = new JList();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButtonCancel = new JButton();
        this.jButtonOk = new JButton();
        this.jPanel2 = new JPanel();
        this.jButtonSelect = new JButton();
        this.jButtonRemove = new JButton();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.setDefaultCloseOperation(2);
        this.jListPossibleValues.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jListPossibleValues);
        this.jListSelectedValues.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.jListSelectedValues);
        this.jLabel1.setText(NbBundle.getMessage(ValuesDialog.class, (String)"ValuesDialog.jLabel1.text"));
        this.jButtonCancel.setText(NbBundle.getMessage(ValuesDialog.class, (String)"ValuesDialog.jButtonCancel.text"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValuesDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOk.setText(NbBundle.getMessage(ValuesDialog.class, (String)"ValuesDialog.jButtonOk.text"));
        this.jButtonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValuesDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(480, Short.MAX_VALUE).addComponent(this.jButtonOk, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonCancel)));
        jPanel1Layout.linkSize(0, this.jButtonCancel, this.jButtonOk);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOk)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonCancel, this.jButtonOk);
        this.jButtonSelect.setText(NbBundle.getMessage(ValuesDialog.class, (String)"ValuesDialog.jButtonSelect.text"));
        this.jButtonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValuesDialog.this.jButtonSelectActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText(NbBundle.getMessage(ValuesDialog.class, (String)"ValuesDialog.jButtonRemove.text"));
        this.jButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValuesDialog.this.jButtonRemoveActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonRemove, -2, 112, -2).addComponent(this.jButtonSelect, -2, 112, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.jButtonRemove, this.jButtonSelect);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.jButtonSelect).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonRemove).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(1, this.jButtonRemove, this.jButtonSelect);
        this.jPanel3.setPreferredSize(new Dimension(132, 132));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 132, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 132, Short.MAX_VALUE));
        this.jPanel4.setPreferredSize(new Dimension(132, 132));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 132, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 119, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 626, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 240, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 242, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 338, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 338, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -1, 119, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGap(27, 27, 27).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void jButtonSelectActionPerformed(ActionEvent evt) {
        int[] listOfSelectedIndices = this.jListPossibleValues.getSelectedIndices();
        if (listOfSelectedIndices.length > 0) {
            int i;
            int looplength = listOfSelectedIndices.length;
            if (this.filterCriteria.getSelectedValues() == null) {
                this.filterCriteria.setSelectedValues(new ArrayList());
            }
            for (i = 0; i < looplength; ++i) {
                this.selectedListModel.addElement(this.possibleListModel.get(listOfSelectedIndices[i]));
            }
            for (i = 0; i < looplength; ++i) {
                this.possibleListModel.remove(listOfSelectedIndices[0]);
                listOfSelectedIndices = this.jListPossibleValues.getSelectedIndices();
            }
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        int[] listOfSelectedIndices = this.jListSelectedValues.getSelectedIndices();
        if (listOfSelectedIndices.length > 0) {
            int i;
            int looplength = listOfSelectedIndices.length;
            for (i = 0; i < looplength; ++i) {
                this.possibleListModel.addElement(this.selectedListModel.get(listOfSelectedIndices[i]));
            }
            for (i = 0; i < looplength; ++i) {
                this.selectedListModel.remove(listOfSelectedIndices[0]);
                listOfSelectedIndices = this.jListSelectedValues.getSelectedIndices();
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.filterCriteria.setSelectedValues(this.tempSelectedValues);
        if (this.tempSelectedValues != null) {
            for (int i = 0; i < this.tempSelectedValues.size(); ++i) {
                this.selectedString = this.selectedString + "\"" + this.tempSelectedValues.get(i).getDescription() + "\" ";
            }
        }
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.filterCriteria.setSelectedValues(new ArrayList());
        for (int i = 0; i < this.selectedListModel.getSize(); ++i) {
            this.filterCriteria.addSelectedValue((FilterValue)this.selectedListModel.get(i));
            this.selectedString = this.selectedString + "\"" + ((FilterValue)this.selectedListModel.get(i)).getDescription() + "\" ";
        }
        this.dispatchEvent(new WindowEvent(this, 201));
    }
}

