/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.filter.action;

import java.awt.Component;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionFieldEnum;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.gui.action.ApplyFilterToTreeTableAction;
import uk.gov.nationalarchives.droid.gui.filter.DatePicker;
import uk.gov.nationalarchives.droid.gui.filter.FilterDialog;
import uk.gov.nationalarchives.droid.gui.filter.TextBoxAndButton;
import uk.gov.nationalarchives.droid.gui.filter.domain.FilterValidationException;
import uk.gov.nationalarchives.droid.gui.filter.domain.GenericMetadata;
import uk.gov.nationalarchives.droid.profile.FilterCriterionImpl;

public class ApplyFilterAction {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void applyFilter(FilterDialog filterDialog) {
        DefaultTableModel tableModel = (DefaultTableModel)filterDialog.getFilterTable().getModel();
        ArrayList<String> errorStrings = new ArrayList<String>();
        for (int i = 0; i < tableModel.getRowCount() - 1; ++i) {
            JComboBox comboBox1 = (JComboBox)tableModel.getValueAt(i, 0);
            CriterionFieldEnum firstComboBoxSelectedItem = (CriterionFieldEnum)comboBox1.getSelectedItem();
            Component componentAtThirdRow = (Component)tableModel.getValueAt(i, 2);
            String freeTextAtRow = null;
            try {
                if (componentAtThirdRow instanceof TextBoxAndButton) {
                    freeTextAtRow = ((TextBoxAndButton)componentAtThirdRow).getTextField().getText();
                } else if (componentAtThirdRow instanceof DatePicker) {
                    freeTextAtRow = ((DatePicker)componentAtThirdRow).getDateString();
                } else {
                    String message = "Error applying filter values from user interface.";
                    this.log.error(message);
                    throw new RuntimeException(message);
                }
                GenericMetadata metadata = filterDialog.getFilterDomain().getMetaDataFromFieldType(firstComboBoxSelectedItem);
                metadata.validate(freeTextAtRow);
            }
            catch (FilterValidationException filterValidationException) {
                errorStrings.add(filterValidationException.getMessage());
            }
            FilterCriterionImpl filterCriteria = filterDialog.getFilterContext().getFilterCriterion(i);
            filterCriteria.setValueFreeText(freeTextAtRow);
        }
        if (errorStrings.size() > 0) {
            JOptionPane.showMessageDialog(filterDialog, errorStrings.toArray());
        } else {
            filterDialog.getDroidContext().getSelectedProfile().getProfile().setDirty(true);
            ProfileForm profileToFilter = filterDialog.getDroidContext().getSelectedProfile();
            ApplyFilterToTreeTableAction applyFilterToTreeAction = new ApplyFilterToTreeTableAction(profileToFilter, filterDialog.getProfileManager());
            applyFilterToTreeAction.applyFilter();
            filterDialog.dispatchEvent(new WindowEvent(filterDialog, 201));
        }
    }
}

