/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.filter.action;

import java.awt.Component;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableModel;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionFieldEnum;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionOperator;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterValue;
import uk.gov.nationalarchives.droid.gui.filter.DatePicker;
import uk.gov.nationalarchives.droid.gui.filter.FilterDialog;
import uk.gov.nationalarchives.droid.gui.filter.TextBoxAndButton;
import uk.gov.nationalarchives.droid.gui.filter.domain.ExtensionMismatchMetadata;
import uk.gov.nationalarchives.droid.gui.filter.domain.GenericMetadata;
import uk.gov.nationalarchives.droid.gui.filter.domain.LastModifiedDateMetadata;
import uk.gov.nationalarchives.droid.profile.FilterCriterionImpl;

public class LoadFilterAction {
    public void loadFilter(FilterDialog filterDialog) {
        DefaultTableModel tableModel = (DefaultTableModel)filterDialog.getFilterTable().getModel();
        for (int row = tableModel.getRowCount() - 2; row >= 0; --row) {
            tableModel.removeRow(row);
        }
        Component component = null;
        Map criteriaMap = filterDialog.getFilterContext().getFilterCriteriaMap();
        for (int i = 0; i < criteriaMap.size(); ++i) {
            tableModel.addRow(filterDialog.getRowForTable());
            filterDialog.getFilterTable().revalidate();
            FilterCriterionImpl filterCriteria = (FilterCriterionImpl)criteriaMap.get(i);
            JComboBox metaDataComboBox = (JComboBox)tableModel.getValueAt(i, 0);
            JComboBox optionComboBox = (JComboBox)tableModel.getValueAt(i, 1);
            CriterionFieldEnum metadaName = filterCriteria.getField();
            GenericMetadata metadata = filterDialog.getFilterDomain().getMetaDataFromFieldType(metadaName);
            metaDataComboBox.getModel().setSelectedItem(metadata.getField());
            DefaultComboBoxModel secondComboBox = (DefaultComboBoxModel)optionComboBox.getModel();
            secondComboBox.removeAllElements();
            for (CriterionOperator metaDataItem : metadata.getOperationList()) {
                secondComboBox.addElement(metaDataItem);
            }
            secondComboBox.setSelectedItem(filterCriteria.getOperator());
            if (metadata instanceof LastModifiedDateMetadata) {
                component = new DatePicker();
                component.setDateCombos(filterCriteria.getValueFreeText());
            } else {
                component = metadata instanceof ExtensionMismatchMetadata ? this.configureComboBox(filterCriteria, metadata) : this.configureTextBoxAndButton(filterDialog, i, filterCriteria, metadata);
            }
            tableModel.setValueAt(component, i, 2);
        }
    }

    private Component configureTextBoxAndButton(FilterDialog filterDialog, int i, FilterCriterionImpl filterCriteria, GenericMetadata metadata) {
        TextBoxAndButton component = new TextBoxAndButton(filterDialog);
        component.getTextField().setText(filterCriteria.getValueFreeText());
        FilterCriterionImpl fci = filterDialog.getFilterContext().getFilterCriterion(i);
        component.setType(metadata, fci);
        if (metadata.isFreeText()) {
            component.getButton().hide();
            filterDialog.getFilterTable().repaint();
        } else {
            component.getTextField().disable();
        }
        return component;
    }

    private Component configureComboBox(FilterCriterionImpl filterCriteria, GenericMetadata metadata) {
        JComboBox<String> combo = new JComboBox<String>();
        for (FilterValue v : metadata.getPossibleValues()) {
            combo.addItem(v.getDescription());
        }
        combo.setSelectedItem(filterCriteria.getValue().toString());
        JComboBox<String> component = combo;
        return component;
    }
}

