/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.filter.domain;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionFieldEnum;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionOperator;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterValue;
import uk.gov.nationalarchives.droid.gui.filter.domain.FilterValidationException;
import uk.gov.nationalarchives.droid.gui.filter.domain.GenericMetadata;

public class ExtensionMismatchMetadata
extends GenericMetadata {
    private static final String DISPLAY_NAME = "File Ext-PUID mismatch";
    private static final Pattern BOOLEAN_STR_REGEX = Pattern.compile("true|false|yes|no", 2);
    private static final Matcher BOOLEAN_MATCHER = BOOLEAN_STR_REGEX.matcher("");

    public ExtensionMismatchMetadata() {
        super(CriterionFieldEnum.EXTENSION_MISMATCH);
        this.addOperation(CriterionOperator.EQ);
        this.addPossibleValue(new FilterValue(1, Boolean.toString(Boolean.TRUE), Boolean.toString(Boolean.TRUE)));
        this.addPossibleValue(new FilterValue(2, Boolean.toString(Boolean.FALSE), Boolean.toString(Boolean.FALSE)));
    }

    @Override
    public void validate(String stringToValidate) throws FilterValidationException {
        BOOLEAN_MATCHER.reset(stringToValidate);
        if (!BOOLEAN_MATCHER.matches()) {
            throw new FilterValidationException("Extension Mismatch must be true or false!");
        }
    }

    @Override
    public boolean isFreeText() {
        return false;
    }
}

