/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.filter.domain;

import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionFieldEnum;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionOperator;
import uk.gov.nationalarchives.droid.gui.filter.domain.FilterValidationException;
import uk.gov.nationalarchives.droid.gui.filter.domain.GenericMetadata;

public class FormatCountMetaData
extends GenericMetadata {
    private static final int ALLOWEDNOOFDIGITS = 18;

    public FormatCountMetaData() {
        super(CriterionFieldEnum.IDENTIFICATION_COUNT);
        this.addOperation(CriterionOperator.EQ);
        this.addOperation(CriterionOperator.NE);
        this.addOperation(CriterionOperator.LT);
        this.addOperation(CriterionOperator.GT);
        this.addOperation(CriterionOperator.LTE);
        this.addOperation(CriterionOperator.GTE);
    }

    @Override
    public void validate(String stringTovalidate) throws FilterValidationException {
        if (stringTovalidate.length() > 18) {
            throw new FilterValidationException("Format count cannot be more than 18 digits long");
        }
        try {
            Long.parseLong(stringTovalidate);
        }
        catch (NumberFormatException e) {
            throw new FilterValidationException("Format count must be numeric and can not be left blank");
        }
    }
}

