/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.filter.domain;

import org.apache.commons.lang.StringUtils;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionFieldEnum;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionOperator;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterValue;
import uk.gov.nationalarchives.droid.gui.filter.domain.FilterValidationException;
import uk.gov.nationalarchives.droid.gui.filter.domain.GenericMetadata;

public class ResourceTypeMetadata
extends GenericMetadata {
    public ResourceTypeMetadata() {
        super(CriterionFieldEnum.RESOURCE_TYPE);
        this.addOperation(CriterionOperator.ANY_OF);
        this.addOperation(CriterionOperator.NONE_OF);
        int index = 0;
        for (ResourceType resourceType : ResourceType.values()) {
            this.addPossibleValue(new FilterValue(index++, resourceType.getResourceType(), String.valueOf(resourceType.ordinal())));
        }
    }

    @Override
    public boolean isFreeText() {
        return false;
    }

    @Override
    public void validate(String stringTovalidate) throws FilterValidationException {
        if (StringUtils.isBlank((String)stringTovalidate)) {
            throw new FilterValidationException("Resource Type can not be blank");
        }
    }
}

