/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.report;

import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.gui.widgetwrapper.SaveAsFileChooser;
import uk.gov.nationalarchives.droid.report.ReportTransformException;
import uk.gov.nationalarchives.droid.report.ReportTransformer;

public class ExportReportAction {
    private static final String XHTML_TRANSFORM_LOCATION = "Web page.html.xsl";
    private ReportTransformer reportTransformer;
    private SaveAsFileChooser exportFileChooser;
    private Path droidReportXml;
    private List<ExportType> exportTypes;
    private Path lastSelectedDir;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public ExportReportAction() {
    }

    public ExportReportAction(ReportTransformer reportTransformer, Path droidReportXML, List<ExportType> exportTypes) {
        this.setReportTransformer(reportTransformer);
        this.setDroidReportXml(droidReportXML);
        this.exportTypes = exportTypes;
    }

    public void execute(Window parent, List<Path> xslTransforms) {
        this.setExportTypes(xslTransforms);
        this.setFileFilters();
        int result = this.exportFileChooser.showSaveDialog(parent);
        if (result == 0) {
            ExportType exporter = (ExportType)this.exportFileChooser.getFileFilter();
            exporter.handleExport(this);
            this.lastSelectedDir = this.exportFileChooser.getSelectedFile().toPath().getParent();
        }
    }

    public void init() {
    }

    private void initialiseSaveAsDialog() {
        this.exportFileChooser = new SaveAsFileChooser();
        this.exportFileChooser.setSelectedFile(this.lastSelectedDir == null ? null : this.lastSelectedDir.toFile());
        this.exportFileChooser.setAcceptAllFileFilterUsed(false);
        String dialogTitle = "Export Report";
        this.exportFileChooser.setWarningDialogTitle("Export Report");
        this.exportFileChooser.setWarningMessage("%s already exists.\nDo you want to replace it?");
        this.exportFileChooser.setWrongExtensionMessage("%s does not have the correct extension %s.\nDo you want to append the right extension?");
        this.exportFileChooser.setDialogTitle("Export Report");
    }

    private void setExportTypes(List<Path> xslTransforms) {
        this.exportTypes = new ArrayList<ExportType>();
        for (Path xslFile : xslTransforms) {
            String baseName = FilenameUtils.getBaseName((String)xslFile.getFileName().toString());
            int stop = baseName.indexOf(46);
            if (stop <= -1) continue;
            String description = baseName.substring(0, stop);
            String extension = baseName.substring(stop + 1);
            this.exportTypes.add(new XSLExportType(extension, description, xslFile));
        }
        this.exportTypes.add(new DroidXMLExportType());
        this.exportTypes.add(new PDFExportType());
    }

    private void setFileFilters() {
        this.initialiseSaveAsDialog();
        for (ExportType exporter : this.exportTypes) {
            this.exportFileChooser.addChoosableFileFilterWithDefaultExtension(exporter, exporter.getFileExtension());
        }
        if (this.exportFileChooser.getFileFilter() == null && this.exportTypes.size() > 0) {
            this.exportFileChooser.setFileFilter(this.exportTypes.get(0));
        }
    }

    public void setReportTransformer(ReportTransformer reportTransformer) {
        this.reportTransformer = reportTransformer;
    }

    public void setDroidReportXml(Path droidReportXml) {
        this.droidReportXml = droidReportXml;
    }

    private List<ExportType> getExportTypes() {
        return null;
    }

    private class XSLExportType
    extends ExportType {
        private Path xslFile;

        public XSLExportType(String fileExtension, String exportDescription, Path xslFile) {
            super(fileExtension, exportDescription);
            this.xslFile = xslFile;
        }

        @Override
        public void handleExport(ExportReportAction action) {
            Path target = action.exportFileChooser.getSelectedFile().toPath();
            this.logReportExport(target.toAbsolutePath().toString());
            try (BufferedReader reader = Files.newBufferedReader(action.droidReportXml, StandardCharsets.UTF_8);
                 BufferedWriter out = Files.newBufferedWriter(target, StandardCharsets.UTF_8, new OpenOption[0]);){
                action.reportTransformer.transformUsingXsl((Reader)reader, this.xslFile, (Writer)out);
            }
            catch (IOException | TransformerException e) {
                ExportReportAction.this.log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private class DroidXMLExportType
    extends ExportType {
        public DroidXMLExportType() {
            super("xml", "DROID Report XML");
        }

        @Override
        public void handleExport(ExportReportAction action) {
            Path target = action.exportFileChooser.getSelectedFile().toPath();
            this.logReportExport(target.toAbsolutePath().toString());
            try {
                Files.copy(action.droidReportXml, target, new CopyOption[0]);
            }
            catch (IOException e) {
                ExportReportAction.this.log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private class PDFExportType
    extends ExportType {
        public PDFExportType() {
            super("pdf", "Adobe Portable Document Format");
        }

        @Override
        public void handleExport(ExportReportAction action) {
            Path target = action.exportFileChooser.getSelectedFile().toPath();
            this.logReportExport(target.toAbsolutePath().toString());
            try (BufferedReader reader = Files.newBufferedReader(action.droidReportXml, StandardCharsets.UTF_8);
                 BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(target, new OpenOption[0]));){
                action.reportTransformer.transformToPdf((Reader)reader, ExportReportAction.XHTML_TRANSFORM_LOCATION, (OutputStream)out);
            }
            catch (IOException | ReportTransformException e) {
                ExportReportAction.this.log.error(e.getMessage(), e);
                throw new RuntimeException(e);
            }
        }
    }

    private abstract class ExportType
    extends FileFilter {
        static final String DESC_PATTERN = "%s (*.%s)";
        private final String fileExtension;
        private final String exportDescription;

        public ExportType(String fileExtension, String exportDescription) {
            this.fileExtension = fileExtension;
            this.exportDescription = exportDescription;
        }

        @Override
        public String getDescription() {
            return String.format(DESC_PATTERN, this.exportDescription, this.fileExtension);
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || FilenameUtils.isExtension((String)f.getName(), (String)this.fileExtension);
        }

        public abstract void handleExport(ExportReportAction var1);

        protected void logReportExport(String filename) {
            String message = String.format("Exporting report as [%s] to: [%s]", this.exportDescription, filename);
            ExportReportAction.this.log.info(message);
        }
    }
}

