/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.report;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.gui.report.ExportReportAction;
import uk.gov.nationalarchives.droid.gui.report.ReportProgressDialog;
import uk.gov.nationalarchives.droid.gui.report.ReportViewFrame;
import uk.gov.nationalarchives.droid.report.interfaces.CancellableProgressObserver;
import uk.gov.nationalarchives.droid.report.interfaces.Report;
import uk.gov.nationalarchives.droid.report.interfaces.ReportCancelledException;
import uk.gov.nationalarchives.droid.report.interfaces.ReportManager;
import uk.gov.nationalarchives.droid.report.interfaces.ReportRequest;
import uk.gov.nationalarchives.droid.report.interfaces.ReportSpec;
import uk.gov.nationalarchives.droid.report.interfaces.ReportXmlWriter;

public class ReportAction
extends SwingWorker<Void, Integer> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<String> profileIds;
    private ReportManager reportManager;
    private ReportXmlWriter reportXmlWriter;
    private ReportSpec reportSpec;
    private ReportProgressDialog progressDialog;
    private ReportViewFrame viewDialog;
    private DroidGlobalConfig config;
    private ExportReportAction exportReportAction;
    private Path targetFile;
    private CancellableProgressObserver backgroundProgressObserver;

    public ReportAction() {
        this.setBackgroundProgressObserver();
    }

    public ReportAction(DroidGlobalConfig config, ReportManager reportManager, ReportXmlWriter reportXmlWriter, ReportSpec reportSpec, ReportProgressDialog progressDialog, ReportViewFrame viewDialog, ExportReportAction exportReportAction, List<String> profileIds) {
        this.setBackgroundProgressObserver();
        this.setConfig(config);
        this.setReportManager(reportManager);
        this.setReportXmlWriter(reportXmlWriter);
        this.setReportSpec(reportSpec);
        this.setProgressDialog(progressDialog);
        this.setViewDialog(viewDialog);
        this.setExportReportAction(exportReportAction);
        this.setProfileIds(profileIds);
    }

    private void setBackgroundProgressObserver() {
        this.backgroundProgressObserver = new CancellableProgressObserver(){
            private boolean cancelled;

            public void onProgress(Integer progress) {
                ReportAction.this.publish(new Integer[]{progress});
            }

            public void cancel() {
                this.cancelled = true;
            }

            public boolean isCancelled() {
                return this.cancelled;
            }
        };
    }

    @Override
    protected void done() {
        try {
            this.get();
        }
        catch (ExecutionException e) {
            this.log.error(e.getCause().toString(), (Throwable)e);
        }
        catch (InterruptedException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
        }
    }

    public void cancel() {
        this.backgroundProgressObserver.cancel();
        this.progressDialog.setVisible(false);
        this.progressDialog.dispose();
    }

    public void setReportManager(ReportManager reportManager) {
        this.reportManager = reportManager;
    }

    @Override
    protected Void doInBackground() {
        ReportRequest request = new ReportRequest();
        request.setReportSpec(this.reportSpec);
        request.setProfileIds(this.profileIds);
        try {
            this.targetFile = Files.createTempFile(this.config.getTempDir(), "report~", ".xml", new FileAttribute[0]);
            Report report = this.reportManager.generateReport(request, null, this.backgroundProgressObserver);
            try (BufferedWriter writer = Files.newBufferedWriter(this.targetFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                this.reportXmlWriter.writeReport(report, (Writer)writer);
            }
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ReportCancelledException e) {
            this.cancel(false);
            this.log.info("Report cancelled by user.");
        }
        return null;
    }

    @Override
    protected void process(List<Integer> chunks) {
        for (Integer i : chunks) {
            this.progressDialog.onProgress(i);
        }
    }

    public void setProfileIds(List<String> profileIds) {
        this.profileIds = profileIds;
    }

    public void setReportXmlWriter(ReportXmlWriter reportXmlWriter) {
        this.reportXmlWriter = reportXmlWriter;
    }

    public void setReportSpec(ReportSpec reportSpec) {
        this.reportSpec = reportSpec;
    }

    public void setViewDialog(ReportViewFrame viewDialog) {
        this.viewDialog = viewDialog;
    }

    public void setConfig(DroidGlobalConfig config) {
        this.config = config;
    }

    public void setProgressDialog(ReportProgressDialog progressDialog) {
        this.progressDialog = progressDialog;
        this.addPropertyChangeListener(new ReportFinishedListener());
    }

    public void setExportReportAction(ExportReportAction exportReportAction) {
        this.exportReportAction = exportReportAction;
    }

    private final class ReportFinishedListener
    implements PropertyChangeListener {
        private ReportFinishedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("state".equals(evt.getPropertyName()) && SwingWorker.StateValue.DONE == evt.getNewValue()) {
                ReportAction.this.progressDialog.setVisible(false);
                ReportAction.this.progressDialog.dispose();
                ReportAction.this.viewDialog.renderReport(ReportAction.this.targetFile, ReportAction.this.reportSpec.getXslTransforms());
                ReportAction.this.viewDialog.setExportAction(ReportAction.this.exportReportAction);
                ReportAction.this.viewDialog.setVisible(true);
            }
        }
    }
}

