/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.report;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.openide.util.NbBundle;
import uk.gov.nationalarchives.droid.gui.DroidMainFrame;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.report.interfaces.ReportSpec;

public class ReportDialog
extends JDialog {
    private static final long serialVersionUID = -4598078880004073202L;
    private DroidMainFrame droidMain;
    private DefaultTableModel tableModel;
    private List<ProfileWrapper> profilesRowData;
    private boolean approved;
    private JButton cancelButton;
    private JButton generateButton;
    private JScrollPane jScrollPane1;
    private JLabel profileSelectLabel;
    private JTable profileSelectTable;
    private JComboBox reportSelectCombo;
    private JLabel reportSelectLabel;

    public ReportDialog(DroidMainFrame parent) {
        super(parent);
        this.droidMain = parent;
        this.setModal(true);
        this.initComponents();
        this.jScrollPane1.getViewport().setBackground(this.profileSelectTable.getBackground());
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void showDialog() {
        this.profilesRowData = new ArrayList<ProfileWrapper>();
        Collection<ProfileForm> profiles = this.droidMain.getDroidContext().allProfiles();
        for (ProfileForm profileForm : profiles) {
            this.profilesRowData.add(new ProfileWrapper(profileForm));
        }
        this.profilesRowData.sort(Comparator.comparing(profileWrapper -> profileWrapper.getProfile().getProfile().getName()));
        this.tableModel = new DefaultTableModel(0, 1){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return ProfileForm.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return ((ProfileWrapper)ReportDialog.this.profilesRowData.get(row)).getProfile().getProfile().getState().isReportable();
            }
        };
        for (ProfileWrapper profileWrapper2 : this.profilesRowData) {
            Object[] row = new Object[]{profileWrapper2};
            this.tableModel.addRow(row);
        }
        this.profileSelectTable.setModel(this.tableModel);
        this.profileSelectTable.setDefaultEditor(ProfileForm.class, new CheckBoxEditor());
        this.profileSelectTable.setDefaultRenderer(ProfileForm.class, new CheckBoxRenderer());
        this.jScrollPane1.setColumnHeaderView(null);
        this.profileSelectTable.setCellSelectionEnabled(false);
        this.reportSelectCombo.setEditable(false);
        ReportSpecRenderer renderer = new ReportSpecRenderer();
        this.reportSelectCombo.setRenderer(renderer);
        DefaultComboBoxModel<ReportSpec> defaultComboBoxModel = new DefaultComboBoxModel<ReportSpec>();
        List reports = this.droidMain.getGlobalContext().getReportManager().listReportSpecs();
        reports.sort(Comparator.comparing(ReportSpec::getName));
        for (ReportSpec reportSpec : reports) {
            defaultComboBoxModel.addElement(reportSpec);
        }
        this.reportSelectCombo.setModel(defaultComboBoxModel);
        this.enableGenerateButton();
        this.approved = false;
        this.setVisible(true);
    }

    public List<String> getSelectedProfileIds() {
        ArrayList<String> selectedProfiles = new ArrayList<String>();
        for (ProfileWrapper profileWrapper : this.profilesRowData) {
            if (!profileWrapper.isSelected()) continue;
            selectedProfiles.add(profileWrapper.getProfile().getProfile().getUuid());
        }
        return selectedProfiles;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.generateButton = new JButton();
        this.profileSelectLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.profileSelectTable = new JTable();
        this.reportSelectLabel = new JLabel();
        this.reportSelectCombo = new JComboBox();
        this.setTitle(NbBundle.getMessage(ReportDialog.class, (String)"ReportDialog.title_1"));
        this.cancelButton.setText(NbBundle.getMessage(ReportDialog.class, (String)"ReportDialog.cancelButton.text"));
        this.cancelButton.setVerticalAlignment(3);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.generateButton.setText(NbBundle.getMessage(ReportDialog.class, (String)"ReportDialog.generateButton.text"));
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportDialog.this.generateButtonActionPerformed(evt);
            }
        });
        this.profileSelectLabel.setText(NbBundle.getMessage(ReportDialog.class, (String)"ReportDialog.profileSelectLabel.text_1"));
        this.profileSelectTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1"}));
        this.profileSelectTable.setRowHeight(20);
        this.profileSelectTable.setRowSelectionAllowed(false);
        this.profileSelectTable.setShowHorizontalLines(false);
        this.profileSelectTable.setShowVerticalLines(false);
        this.profileSelectTable.setTableHeader(null);
        this.jScrollPane1.setViewportView(this.profileSelectTable);
        this.reportSelectLabel.setText(NbBundle.getMessage(ReportDialog.class, (String)"ReportDialog.reportSelectLabel.text"));
        this.reportSelectCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 450, Short.MAX_VALUE).addComponent(this.profileSelectLabel, GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.generateButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton, -2, 125, -2)).addGroup(layout.createSequentialGroup().addComponent(this.reportSelectLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reportSelectCombo, 0, 384, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.profileSelectLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 143, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.reportSelectCombo, -2, 20, -2).addComponent(this.reportSelectLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.generateButton, -1, -1, Short.MAX_VALUE).addComponent(this.cancelButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        this.approved = true;
        this.setVisible(false);
    }

    private void enableGenerateButton() {
        boolean profileSelected = false;
        for (ProfileWrapper profileWrapper : this.profilesRowData) {
            if (!profileWrapper.isSelected()) continue;
            profileSelected = true;
            break;
        }
        this.generateButton.setEnabled(profileSelected);
    }

    public ReportSpec getSelectedReportSpec() {
        return (ReportSpec)this.reportSelectCombo.getSelectedItem();
    }

    public boolean isApproved() {
        return this.approved;
    }

    private final class ReportSpecRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 6009453525457078052L;

        public ReportSpecRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof ReportSpec) {
                ReportSpec spec = (ReportSpec)value;
                this.setText(spec.getName());
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private final class ProfileWrapper {
        private ProfileForm profile;
        private boolean selected;

        ProfileWrapper(ProfileForm profile) {
            this.profile = profile;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            ReportDialog.this.enableGenerateButton();
        }

        public boolean isSelected() {
            return this.selected;
        }

        public ProfileForm getProfile() {
            return this.profile;
        }
    }

    private final class CheckBoxEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 8023412072260282004L;
        private ProfileWrapper profile;

        public CheckBoxEditor() {
            super(new JCheckBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.profile = (ProfileWrapper)value;
            JCheckBox checkBox = (JCheckBox)this.getComponent();
            checkBox.setText(this.profile.getProfile().getName());
            checkBox.setSelected(this.profile.isSelected());
            checkBox.setOpaque(false);
            return checkBox;
        }

        @Override
        public Object getCellEditorValue() {
            this.profile.setSelected(((JCheckBox)this.getComponent()).isSelected());
            return this.profile;
        }
    }

    private final class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -4078523535790396904L;

        private CheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ProfileWrapper profile = (ProfileWrapper)value;
            this.setSelected(profile.isSelected());
            this.setText(profile.getProfile().getName());
            this.setOpaque(false);
            boolean enabled = ((ProfileWrapper)ReportDialog.this.profilesRowData.get(row)).getProfile().getProfile().getState().isReportable();
            this.setEnabled(enabled);
            return this;
        }
    }
}

