/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.treemodel;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;
import uk.gov.nationalarchives.droid.gui.treemodel.DirectoryComparable;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;

public abstract class DirectoryComparableObject<T extends Comparable<T>>
implements DirectoryComparable<T> {
    private T source;
    private ProfileResourceNode node;

    public DirectoryComparableObject(T source, ProfileResourceNode node) {
        this.source = source;
        this.node = node;
    }

    @Override
    public int compareTo(DirectoryComparable<T> o) {
        return this.nullSafeCompareTo(o);
    }

    private int nullSafeCompareTo(DirectoryComparable<T> o) {
        int compare = this.source == null && o == null ? 0 : (this.source == null ? -1 : (o == null || o.getSource() == null ? 1 : this.sourceCompareTo(o)));
        return compare;
    }

    protected int sourceCompareTo(DirectoryComparable<T> o) {
        return this.source.compareTo((Comparable)((Comparable)o.getSource()));
    }

    public String toString() {
        return this.source == null ? "" : this.source.toString();
    }

    @Override
    public T getSource() {
        return this.source;
    }

    @Override
    public int getFilterStatus() {
        return this.node.getFilterStatus();
    }

    public boolean getExtensionMismatch() {
        return this.node.getExtensionMismatch();
    }

    @Override
    public ResourceType getResourceType() {
        return this.node.getMetaData().getResourceType();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.source).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectoryComparableObject other = (DirectoryComparableObject)obj;
        return new EqualsBuilder().append(this.source, other.source).isEquals();
    }
}

