/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.treemodel;

import java.awt.Cursor;
import java.util.Enumeration;
import java.util.List;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;

public class ExpandingTreeListener
implements TreeWillExpandListener {
    private ProfileManager profileManager;
    private ProfileForm profileForm;

    public ExpandingTreeListener(ProfileManager profileManager, ProfileForm profileForm) {
        this.profileManager = profileManager;
        this.profileForm = profileForm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void treeWillExpand(TreeExpansionEvent event) {
        try {
            this.profileForm.setCursor(Cursor.getPredefinedCursor(3));
            DefaultMutableTreeNode expandingNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
            ProfileResourceNode prn = (ProfileResourceNode)expandingNode.getUserObject();
            this.profileForm.getInMemoryNodes().put(prn.getId(), expandingNode);
            expandingNode.removeAllChildren();
            List childNodes = this.profileManager.findProfileResourceNodeAndImmediateChildren(this.profileForm.getProfile().getUuid(), prn.getId());
            if (!childNodes.isEmpty()) {
                expandingNode.setAllowsChildren(true);
                for (ProfileResourceNode node : childNodes) {
                    DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(node, node.allowsChildren());
                    expandingNode.add(newNode);
                    this.profileForm.getInMemoryNodes().put(node.getId(), newNode);
                }
            }
            if (expandingNode.getChildCount() == 0) {
                expandingNode.setAllowsChildren(false);
            }
            this.profileForm.getTreeModel().nodeStructureChanged(expandingNode);
        }
        finally {
            this.profileForm.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) {
        DefaultMutableTreeNode collapsingNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        ProfileResourceNode prn = (ProfileResourceNode)collapsingNode.getUserObject();
        this.profileForm.getInMemoryNodes().remove(prn.getId());
        Enumeration<TreeNode> e = collapsingNode.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode nodeToRemove = (DefaultMutableTreeNode)e.nextElement();
            ProfileResourceNode node = (ProfileResourceNode)nodeToRemove.getUserObject();
            this.profileForm.getInMemoryNodes().remove(node.getId());
        }
        collapsingNode.removeAllChildren();
        this.profileForm.getTreeModel().nodeStructureChanged(collapsingNode);
    }
}

