/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.treemodel;

import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import uk.gov.nationalarchives.droid.gui.treemodel.DirectoryComparableLong;
import uk.gov.nationalarchives.droid.gui.treemodel.TreeUtils;

public class FormatCountRenderer
implements TableCellRenderer {
    private static final String ICON_URL_PATTERN = "uk/gov/nationalarchives/droid/icons/format_count_small_%s.png";
    private JLabel nullFormatCount = new JLabel();
    private JLabel zeroFormatCount = new JLabel();
    private JLabel oneFormatCount = new JLabel();
    private JLabel manyFormatCount = new JLabel();
    private Color backColor;
    private Color darkerColor;

    public FormatCountRenderer(Color backColor) {
        this.setLabelProperties(this.nullFormatCount, null);
        this.setLabelProperties(this.zeroFormatCount, 0);
        this.setLabelProperties(this.oneFormatCount, 1);
        this.setLabelProperties(this.manyFormatCount, null);
        this.backColor = backColor;
        this.darkerColor = TreeUtils.getDarkerColor(backColor);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean displayAsLink;
        DirectoryComparableLong count = (DirectoryComparableLong)value;
        JLabel renderer = this.getRenderer(count);
        Long sourceCount = (Long)count.getSource();
        boolean bl = displayAsLink = sourceCount != null && sourceCount > 1L;
        if (displayAsLink && count.getFilterStatus() == 1) {
            renderer.setText("<html>(<u>" + sourceCount + "</u>)</html>");
        } else {
            renderer.setText(null);
        }
        if (isSelected) {
            renderer.setBackground(table.getSelectionBackground());
            renderer.setForeground(table.getSelectionForeground());
        } else {
            renderer.setBackground(this.getBackgroundColor(table, row, column));
            renderer.setForeground(displayAsLink ? Color.BLUE : table.getForeground());
        }
        return renderer;
    }

    private Color getBackgroundColor(JTable table, int row, int column) {
        Color theColor = row % 2 == 0 ? this.backColor : this.darkerColor;
        return theColor;
    }

    private JLabel getRenderer(DirectoryComparableLong count) {
        JLabel result = null;
        Long source = (Long)count.getSource();
        result = source != null && count.getFilterStatus() == 1 ? (source == 1L ? this.oneFormatCount : (source > 1L ? this.manyFormatCount : this.zeroFormatCount)) : this.nullFormatCount;
        return result;
    }

    private void setLabelProperties(JLabel label, Integer count) {
        label.setOpaque(true);
        label.setHorizontalAlignment(0);
        label.setIcon(this.createImageIcon(count));
    }

    private ImageIcon createImageIcon(Integer count) {
        if (count != null) {
            String iconSuffix = count == 1 ? "ONE" : (count > 1 ? "MULTIPLE" : "ZERO");
            URL imgURL = this.getClass().getClassLoader().getResource(String.format(ICON_URL_PATTERN, iconSuffix));
            return imgURL == null ? null : new ImageIcon(imgURL, iconSuffix);
        }
        return null;
    }
}

