/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.treemodel;

import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.TableCellRenderer;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.gui.treemodel.DefaultCellRenderer;
import uk.gov.nationalarchives.droid.gui.treemodel.DirectoryComparableDate;
import uk.gov.nationalarchives.droid.gui.treemodel.DirectoryComparableLong;
import uk.gov.nationalarchives.droid.gui.treemodel.DirectoryComparableString;
import uk.gov.nationalarchives.droid.gui.treemodel.FileExtensionRenderer;
import uk.gov.nationalarchives.droid.gui.treemodel.FileSizeRenderer;
import uk.gov.nationalarchives.droid.gui.treemodel.FormatCountRenderer;
import uk.gov.nationalarchives.droid.gui.treemodel.HyperlinkRenderer;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;

public enum OutlineColumn {
    EXTENSION{

        public Class<DirectoryComparableString> getColumnClass() {
            return DirectoryComparableString.class;
        }

        @Override
        public String getName() {
            return "Extension";
        }

        @Override
        public Object getValue(ProfileResourceNode node) {
            return new DirectoryComparableString(node.getMetaData().getExtension(), node);
        }

        @Override
        public TableCellRenderer getRenderer(Color backColor) {
            return new FileExtensionRenderer(backColor);
        }
    }
    ,
    SIZE{

        public Class<DirectoryComparableLong> getColumnClass() {
            return DirectoryComparableLong.class;
        }

        @Override
        public String getName() {
            return "Size";
        }

        @Override
        public Object getValue(ProfileResourceNode node) {
            return new DirectoryComparableLong(node.getMetaData().getSize(), node);
        }

        @Override
        public TableCellRenderer getRenderer(Color backColor) {
            return new FileSizeRenderer(backColor);
        }
    }
    ,
    DATE{

        public Class<DirectoryComparableDate> getColumnClass() {
            return DirectoryComparableDate.class;
        }

        @Override
        public String getName() {
            return "Last modified";
        }

        @Override
        public Object getValue(ProfileResourceNode node) {
            return new DirectoryComparableDate(node.getMetaData().getLastModifiedDate(), node);
        }

        @Override
        public TableCellRenderer getRenderer(Color backColor) {
            return new DefaultCellRenderer(backColor, 0);
        }
    }
    ,
    IDENTIFICATION_COUNT{

        @Override
        public Class<?> getColumnClass() {
            return DirectoryComparableLong.class;
        }

        @Override
        public String getName() {
            return "Ids";
        }

        @Override
        public Object getValue(ProfileResourceNode node) {
            Integer identificationCount = node.getIdentificationCount();
            return new DirectoryComparableLong(identificationCount, node);
        }

        @Override
        public TableCellRenderer getRenderer(Color backColor) {
            return new FormatCountRenderer(backColor);
        }
    }
    ,
    FORMAT{

        public Class<DirectoryComparableString> getColumnClass() {
            return DirectoryComparableString.class;
        }

        @Override
        public String getName() {
            return "Format";
        }

        @Override
        public Object getValue(ProfileResourceNode node) {
            String formatValue = null;
            List formatIdentifications = node.getFormatIdentifications();
            if (formatIdentifications.size() == 1) {
                formatValue = ((Format)formatIdentifications.get(0)).getName();
            } else if (formatIdentifications.size() > 1) {
                HashSet<String> formatNames = new HashSet<String>();
                for (Format f : formatIdentifications) {
                    String name = f.getName().trim();
                    if (name.isEmpty()) continue;
                    formatNames.add(name);
                }
                formatValue = OutlineColumn.getMultiValuedString(formatNames);
            }
            return new DirectoryComparableString(formatValue, node);
        }

        @Override
        public TableCellRenderer getRenderer(Color backColor) {
            return new DefaultCellRenderer(backColor, 2);
        }
    }
    ,
    VERSION{

        public Class<DirectoryComparableString> getColumnClass() {
            return DirectoryComparableString.class;
        }

        @Override
        public String getName() {
            return "Version";
        }

        @Override
        public Object getValue(ProfileResourceNode node) {
            String version = null;
            List formatIdentifications = node.getFormatIdentifications();
            if (formatIdentifications.size() == 1) {
                version = ((Format)formatIdentifications.get(0)).getVersion();
            } else if (formatIdentifications.size() > 1) {
                HashSet<String> formatNames = new HashSet<String>();
                for (Format f : formatIdentifications) {
                    String ver = f.getVersion().trim();
                    if (ver.isEmpty()) continue;
                    formatNames.add(ver);
                }
                version = OutlineColumn.getMultiValuedString(formatNames);
            }
            return new DirectoryComparableString(version, node);
        }

        @Override
        public TableCellRenderer getRenderer(Color backColor) {
            return new DefaultCellRenderer(backColor, 0);
        }
    }
    ,
    MIME_TYPE{

        public Class<DirectoryComparableString> getColumnClass() {
            return DirectoryComparableString.class;
        }

        @Override
        public String getName() {
            return "Mime type";
        }

        @Override
        public Object getValue(ProfileResourceNode node) {
            String mimeType = null;
            List formatIdentifications = node.getFormatIdentifications();
            if (formatIdentifications.size() == 1) {
                mimeType = ((Format)formatIdentifications.get(0)).getMimeType();
            } else if (formatIdentifications.size() > 1) {
                HashSet<String> formatNames = new HashSet<String>();
                for (Format f : formatIdentifications) {
                    String mime = f.getMimeType().trim();
                    if (mime.isEmpty()) continue;
                    formatNames.add(mime);
                }
                mimeType = OutlineColumn.getMultiValuedString(formatNames);
            }
            return new DirectoryComparableString(mimeType, node);
        }

        @Override
        public TableCellRenderer getRenderer(Color backColor) {
            return new DefaultCellRenderer(backColor, 2);
        }
    }
    ,
    PUID{

        public Class<DirectoryComparableString> getColumnClass() {
            return DirectoryComparableString.class;
        }

        @Override
        public String getName() {
            return "PUID";
        }

        @Override
        public Object getValue(ProfileResourceNode node) {
            Format format = null;
            String puid = "";
            List formatIdentifications = node.getFormatIdentifications();
            if (formatIdentifications.size() == 1) {
                format = (Format)formatIdentifications.get(0);
                puid = format.getPuid();
            } else if (formatIdentifications.size() > 1) {
                HashSet<String> formatNames = new HashSet<String>();
                for (Format f : formatIdentifications) {
                    String p = f.getPuid();
                    if (p.isEmpty()) continue;
                    formatNames.add(p);
                }
                puid = OutlineColumn.getMultiValuedString(formatNames);
            }
            return new DirectoryComparableString(puid, node);
        }

        @Override
        public TableCellRenderer getRenderer(Color backColor) {
            return new HyperlinkRenderer(backColor, 0);
        }
    }
    ,
    IDENTIFICATION_METHOD{

        public Class<DirectoryComparableString> getColumnClass() {
            return DirectoryComparableString.class;
        }

        @Override
        public String getName() {
            return "Method";
        }

        @Override
        public Object getValue(ProfileResourceNode node) {
            IdentificationMethod method = node.getMetaData().getIdentificationMethod();
            return new DirectoryComparableString(method == null ? "" : method.getMethod(), node);
        }

        @Override
        public TableCellRenderer getRenderer(Color backColor) {
            return new DefaultCellRenderer(backColor);
        }
    }
    ,
    HASH{

        public Class<DirectoryComparableString> getColumnClass() {
            return DirectoryComparableString.class;
        }

        @Override
        public String getName() {
            return "Hash";
        }

        @Override
        public Object getValue(ProfileResourceNode node) {
            String hash = node.getMetaData().getHash();
            return new DirectoryComparableString(hash == null ? "" : hash, node);
        }

        @Override
        public TableCellRenderer getRenderer(Color backColor) {
            return new DefaultCellRenderer(backColor);
        }
    };


    private static String getMultiValuedString(Set<String> values) {
        StringBuilder builder = new StringBuilder();
        String separator = "";
        String format = values.size() > 1 ? "%s\"%s\"" : "%s%s";
        for (String value : values) {
            builder.append(String.format(format, separator, value));
            separator = ", ";
        }
        return builder.toString();
    }

    public abstract Class<?> getColumnClass();

    abstract String getName();

    abstract Object getValue(ProfileResourceNode var1);

    public abstract TableCellRenderer getRenderer(Color var1);
}

