/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.treemodel;

import java.awt.Color;
import java.util.List;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.TableModel;

public final class TreeUtils {
    private static final double LIGHTER_SCALE = 1.05;
    private static final double DARKER_SCALE = 0.95;
    private static final int MINVALUE = 0;
    private static final int MAXVALUE = 255;

    private TreeUtils() {
    }

    private static int getScaledColorComponent(int colorComponent, double scaleFactor) {
        int scaledValue = (int)((double)colorComponent * scaleFactor);
        if (scaledValue < 0) {
            scaledValue = 0;
        } else if (scaledValue > 255) {
            scaledValue = 255;
        }
        return scaledValue;
    }

    public static Color getScaledColor(Color color, double scaleFactor) {
        return new Color(TreeUtils.getScaledColorComponent(color.getRed(), scaleFactor), TreeUtils.getScaledColorComponent(color.getGreen(), scaleFactor), TreeUtils.getScaledColorComponent(color.getBlue(), scaleFactor));
    }

    public static Color getDarkerColor(Color color) {
        return TreeUtils.getScaledColor(color, 0.95);
    }

    public static Color getLighterColor(Color color) {
        return TreeUtils.getScaledColor(color, 1.05);
    }

    public static boolean isColumnSorted(JTable table, int column) {
        boolean isSorted = false;
        int modelColumn = table.convertColumnIndexToModel(column);
        RowSorter<? extends TableModel> sorter = table.getRowSorter();
        if (sorter != null) {
            List<RowSorter.SortKey> sortKeys = sorter.getSortKeys();
            for (RowSorter.SortKey sortKey : sortKeys) {
                if (sortKey.getColumn() != modelColumn) continue;
                isSorted = true;
                break;
            }
        }
        return isSorted;
    }
}

