/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.util;

import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class DroidStringUtils {
    private static final String ELIPSES = "...";

    private DroidStringUtils() {
    }

    public static String abbreviate(String str, int minLeft, int maxLength) {
        int length;
        if (str.length() <= maxLength) {
            return str;
        }
        int left = maxLength - ELIPSES.length();
        int n = left = left >= 0 ? left : 0;
        if (left > minLeft && minLeft >= 0) {
            left = minLeft;
        }
        if (left > (length = str.length())) {
            left = length;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(str.substring(0, left));
        sb.append(ELIPSES);
        int removeCount = length - maxLength + sb.length();
        if (removeCount > 0 && removeCount < length) {
            sb.append(str.substring(removeCount, length));
        }
        return sb.toString();
    }

    public static String abbreviate(String str, JComponent component) {
        String result = "";
        if (component != null) {
            Graphics g = component.getGraphics();
            FontMetrics fm = g.getFontMetrics(component.getFont());
            int stringSize = SwingUtilities.computeStringWidth(fm, str);
            int border = 48;
            int availableWidth = component.getWidth() - 48;
            if (stringSize > availableWidth) {
                int avCharWidth = fm.charWidth('x');
                int alwaysChop = 5;
                int charsToChop = 5 + (stringSize - availableWidth) / avCharWidth;
                int leftPos = (str.length() - charsToChop) / 2;
                int maxLength = str.length() - charsToChop;
                int left = leftPos > 0 ? leftPos : 0;
                int len = maxLength > left ? maxLength : left + 1;
                result = DroidStringUtils.abbreviate(str, left, len);
            } else {
                result = str;
            }
        }
        return result;
    }
}

