/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.widgetwrapper;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class SaveAsFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -6568564046303804534L;
    private String warningDialogTitle;
    private String warningMessage;
    private String wrongExtensionMessage;
    private Map<FileFilter, String> filters = new HashMap<FileFilter, String>();

    @Override
    public void approveSelection() {
        this.checkExtensionForNewFile();
        this.checkExtensionForExistingFile();
        if (this.overwriteConfirmedIfExists()) {
            super.approveSelection();
        }
    }

    private void checkExtensionForNewFile() {
        String defaultExtension;
        File f = this.getSelectedFile();
        if (f != null && !f.exists() && (defaultExtension = this.filters.get(this.getFileFilter())) != null) {
            this.setSelectedFile(SaveAsFileChooser.appendExtension(this.getSelectedFile(), defaultExtension));
        }
    }

    private void checkExtensionForExistingFile() {
        File f = this.getSelectedFile();
        if (f != null && f.exists()) {
            String message;
            int confirm;
            String defaultExtension = this.filters.get(this.getFileFilter());
            if (!FilenameUtils.isExtension((String)f.getName(), (String)defaultExtension) && (confirm = JOptionPane.showConfirmDialog(this, message = String.format(this.wrongExtensionMessage, f.getPath(), defaultExtension), this.warningDialogTitle, 0, 2)) == 0) {
                this.setSelectedFile(SaveAsFileChooser.appendExtension(this.getSelectedFile(), defaultExtension));
            }
        }
    }

    private boolean overwriteConfirmedIfExists() {
        boolean proceed = true;
        File f = this.getSelectedFile();
        if (f != null && f.exists()) {
            String message = String.format(this.warningMessage, f.getPath());
            int confirm = JOptionPane.showConfirmDialog(this, message, this.warningDialogTitle, 0, 2);
            proceed = confirm == 0;
        }
        return proceed;
    }

    public String getSelectedFilterExtension() {
        return this.getFileFilter() == null ? null : this.filters.get(this.getFileFilter());
    }

    private static File appendExtension(File file, String expectedExtension) {
        String fileName = file.getName();
        File f = !FilenameUtils.isExtension((String)fileName, (String)expectedExtension) ? new File(file.getAbsolutePath() + "." + expectedExtension) : file;
        return f;
    }

    public void addChoosableFileFilterWithDefaultExtension(FileFilter filter, String ext) {
        this.filters.put(filter, ext);
        this.addChoosableFileFilter(filter);
    }

    public void setWarningDialogTitle(String warningDialogTitle) {
        this.warningDialogTitle = warningDialogTitle;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public void setWrongExtensionMessage(String wrongExtensionMessage) {
        this.wrongExtensionMessage = wrongExtensionMessage;
    }
}

