/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.worker;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.NodeStatus;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.gui.util.DroidStringUtils;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.ProfileResultObserver;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;

public class DroidJob
extends SwingWorker<Integer, ProfileResourceNode> {
    private static final int RESULT_MAX_LENGTH = 60;
    private static final int RESULT_LEFT_MIN = 20;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ProfileForm profileForm;
    private ProfileManager profileManager;
    private DefaultTreeModel treeModel;

    public DroidJob() {
    }

    public DroidJob(ProfileForm profileForm, ProfileManager profileManager) {
        this.setProfileForm(profileForm);
        this.setProfileManager(profileManager);
    }

    public void setProfileManager(ProfileManager profileManager) {
        this.profileManager = profileManager;
    }

    @Override
    protected void process(List<ProfileResourceNode> chunks) {
        for (ProfileResourceNode node : chunks) {
            Long parentId = node.getParentId() == null ? -1L : node.getParentId();
            DefaultMutableTreeNode parent = this.profileForm.getInMemoryNodes().get(parentId);
            if (parent == null) continue;
            parent.setAllowsChildren(true);
            boolean updated = false;
            Enumeration<TreeNode> e = parent.children();
            while (e.hasMoreElements() && !updated) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)e.nextElement();
                if (!childNode.getUserObject().equals(node)) continue;
                childNode.setUserObject(node);
                childNode.setAllowsChildren(node.allowsChildren());
                this.treeModel.nodeChanged(childNode);
                updated = true;
            }
            if (!updated) {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(node, node.allowsChildren());
                this.treeModel.insertNodeInto(newNode, parent, parent.getChildCount());
            }
            this.treeModel.nodeChanged(parent);
        }
        if (!chunks.isEmpty()) {
            String decodedURI = URLDecoder.decode(chunks.get(0).getUri().toString());
            String abbreviatedUri = DroidStringUtils.abbreviate(decodedURI, this.profileForm.getProfileProgressBar());
            this.profileForm.getProfileProgressBar().setString(abbreviatedUri);
        }
    }

    @Override
    protected Integer doInBackground() throws IOException {
        this.treeModel = this.profileForm.getTreeModel();
        ProfileResultObserver myObserver = new ProfileResultObserver(){

            public void onResult(ProfileResourceNode result) {
                DroidJob.this.publish(new ProfileResourceNode[]{result});
            }
        };
        String profileUuid = this.profileForm.getProfile().getUuid();
        ProgressObserver observer = new ProgressObserver(){

            public void onProgress(Integer progress) {
                DroidJob.this.setProgress(progress);
            }
        };
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName())) {
                    Integer value = (Integer)evt.getNewValue();
                    DroidJob.this.profileForm.getProfileProgressBar().setValue(value);
                }
            }
        });
        this.profileManager.setResultsObserver(profileUuid, myObserver);
        this.profileManager.setProgressObserver(profileUuid, observer);
        try {
            this.profileManager.start(profileUuid).get();
        }
        catch (ExecutionException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getCause().getMessage(), e.getCause());
        }
        catch (InterruptedException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    protected void done() {
        try {
            this.updateRootNode();
            if (!this.isCancelled()) {
                this.get();
            }
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.log.error(cause.getMessage(), (Throwable)e);
            this.profileManager.stop(this.profileForm.getProfile().getUuid());
            JOptionPane.showMessageDialog(this.profileForm, "An error occurred during profiling. Your profile has been paused.", "Error", 0);
        }
        catch (InterruptedException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void updateRootNode() {
        List rootNodeFromDb = this.profileManager.findRootNodes(this.profileForm.getProfile().getUuid());
        if (rootNodeFromDb != null && rootNodeFromDb.size() > 0) {
            for (ProfileResourceNode node : rootNodeFromDb) {
                if (node.getMetaData().getNodeStatus() != NodeStatus.EMPTY) continue;
                this.findAndUpdateNodeInGUI(node);
            }
        }
    }

    private void findAndUpdateNodeInGUI(ProfileResourceNode node) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode dir = (DefaultMutableTreeNode)root.getChildAt(i);
            ProfileResourceNode nodeFromGui = (ProfileResourceNode)dir.getUserObject();
            if (nodeFromGui == null || !node.getUri().equals(nodeFromGui.getUri())) continue;
            dir.setUserObject(node);
            this.treeModel.reload(dir);
            break;
        }
    }

    public void setProfileForm(ProfileForm profileForm) {
        this.profileForm = profileForm;
    }

    public void start() {
        this.execute();
    }
}

